<?php
require_once __DIR__ . '/../config/auth.php';

$action = $_GET['action'] ?? '';
$thread_id = (int)($_GET['id'] ?? 0);
$post_id = (int)($_GET['post_id'] ?? 0);

// Pin/Unpin thread
if ($action === 'pin' && $thread_id > 0) {
    requirePermission('forum.moderate');
    
    $conn->query("UPDATE threads SET is_pinned = NOT is_pinned WHERE id = $thread_id");
    logActivity('thread_pin', "Toggled pin on thread ID: $thread_id");
    
    redirect('thread?id=' . $thread_id);
}

// Lock/Unlock thread
if ($action === 'lock' && $thread_id > 0) {
    requirePermission('forum.moderate');
    
    $conn->query("UPDATE threads SET is_locked = NOT is_locked WHERE id = $thread_id");
    logActivity('thread_lock', "Toggled lock on thread ID: $thread_id");
    
    redirect('thread?id=' . $thread_id);
}

// Delete thread
if ($action === 'delete_thread' && $thread_id > 0) {
    requirePermission('forum.moderate');
    
    // Get thread info for logging
    $thread = $conn->query("SELECT title FROM threads WHERE id = $thread_id")->fetch_assoc();
    
    // Delete thread (cascade will handle posts)
    $conn->query("DELETE FROM threads WHERE id = $thread_id");
    logActivity('thread_delete', "Deleted thread: " . $thread['title']);
    
    redirect('forum');
}

// Edit post
if ($action === 'edit' && $post_id > 0) {
    $post = $conn->query("
        SELECT p.*, t.id as thread_id 
        FROM posts p 
        JOIN threads t ON p.thread_id = t.id 
        WHERE p.id = $post_id
    ")->fetch_assoc();
    
    if (!$post) {
        die('Post not found');
    }
    
    // Check permission
    if ($post['user_id'] != $_SESSION['user_id'] && !hasPermission('forum.moderate')) {
        die('Access denied');
    }
    
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $content = sanitizeInput($_POST['content']);
        $token = $_POST['csrf_token'] ?? '';
        
        if (!verifyToken($token)) {
            die('Invalid token');
        }
        
        $stmt = $conn->prepare("UPDATE posts SET content = ?, is_edited = 1, edited_at = NOW() WHERE id = ?");
        $stmt->bind_param('si', $content, $post_id);
        $stmt->execute();
        
        logActivity('post_edit', "Edited post ID: $post_id");
        
        redirect('thread?id=' . $post['thread_id']);
    }
    
    $page_title = 'Edit Post';
    include __DIR__ . '/../assets/includes/header.php';
    ?>
    
    <div class="page-header">
        <h1>Edit Post</h1>
    </div>
    
    <form method="POST" class="forum-form">
        <input type="hidden" name="csrf_token" value="<?= generateToken() ?>">
        
        <div class="form-group">
            <label for="content">Content</label>
            <textarea name="content" id="content" rows="10" required><?= clean($post['content']) ?></textarea>
        </div>
        
        <button type="submit" class="btn btn-primary no-loading">Save Changes</button>
        <a href="thread?id=<?= $post['thread_id'] ?>" class="btn btn-secondary">Cancel</a>
    </form>
    
    <?php
    include __DIR__ . '/../assets/includes/footer.php';
    exit;
}

// Delete post
if ($action === 'delete' && $post_id > 0) {
    requirePermission('forum.moderate');
    
    $post = $conn->query("SELECT thread_id FROM posts WHERE id = $post_id")->fetch_assoc();
    
    if ($post) {
        $conn->query("DELETE FROM posts WHERE id = $post_id");
        logActivity('post_delete', "Deleted post ID: $post_id");
        
        redirect('thread?id=' . $post['thread_id']);
    }
}

redirect('forum');