<?php
require_once __DIR__ . '/../config/auth.php';

// Check access: Major ADMIN (rank_id 11) or Commaderi (rank_id 9 - Commander PSB) or Deputy Chief+ (level 13+)
$rank_id = $_SESSION['rank_id'] ?? 0;
$rank_level = $_SESSION['rank_level'] ?? 0;

if ($rank_id != 9 && $rank_id != 11 && $rank_level < 13) {
    die('Access denied. Major ADMIN, Commander PSB or Deputy Chief Warden+ only.');
}

$action = $_GET['action'] ?? 'pending_forms';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    validateToken();
    
    $user_id = (int)($_POST['user_id'] ?? 0);
    $new_status = $_POST['status'] ?? '';
    
    if ($user_id > 0 && in_array($new_status, ['active', 'inactive', 'suspended'])) {
        $stmt = $conn->prepare("UPDATE users SET status = ? WHERE id = ?");
        $stmt->bind_param('si', $new_status, $user_id);
        $stmt->execute();
        
        logActivity('hr_action', "Updated user ID $user_id status to $new_status");
        redirect('hr?action=user_status');
    }
}

$page_title = 'Human Resources';
include __DIR__ . '/../assets/includes/header.php';
?>

<div class="page-header">
    <h1>👥 Human Resources</h1>
    <a href="/doc/dashboard" class="btn btn-secondary">← Dashboard</a>
</div>

<div class="admin-tabs">
    <a href="?action=pending_forms" class="tab <?= $action === 'pending_forms' ? 'active' : '' ?>">Pending Forms</a>
    <a href="?action=user_status" class="tab <?= $action === 'user_status' ? 'active' : '' ?>">User Status</a>
</div>

<?php if ($action === 'pending_forms'): ?>
    <div class="page-header">
        <h2>📋 Pending Forms Review</h2>
    </div>
    
    <?php
    // Get pending escorting reports
    $pending_escorts = $conn->query("
        SELECT er.*, u.ic_name, u.badge_number, r.display_name as rank
        FROM escorting_reports er
        JOIN users u ON er.user_id = u.id
        JOIN ranks r ON u.rank_id = r.id
        WHERE er.status IN ('draft', 'submitted')
        ORDER BY er.created_at DESC
    ")->fetch_all(MYSQLI_ASSOC);
    
    // Get pending bolingbroke activities
    $pending_bb = $conn->query("
        SELECT ba.*, u.ic_name, u.badge_number, r.display_name as rank
        FROM bolingbroke_activities ba
        JOIN users u ON ba.user_id = u.id
        JOIN ranks r ON u.rank_id = r.id
        WHERE ba.status IN ('draft', 'submitted')
        ORDER BY ba.created_at DESC
    ")->fetch_all(MYSQLI_ASSOC);
    
    // Get pending parole forms
    $pending_parole = $conn->query("
        SELECT pf.*, u.ic_name, u.badge_number, r.display_name as rank
        FROM parole_forms pf
        JOIN users u ON pf.user_id = u.id
        JOIN ranks r ON u.rank_id = r.id
        WHERE pf.status IN ('draft', 'submitted')
        ORDER BY pf.created_at DESC
    ")->fetch_all(MYSQLI_ASSOC);
    ?>
    
    <div class="form-section">
        <h3>🚓 Escorting Reports (<?= count($pending_escorts) ?>)</h3>
        <?php if (empty($pending_escorts)): ?>
            <p>No pending escorting reports.</p>
        <?php else: ?>
            <table class="data-table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Submitted By</th>
                        <th>IC Escorting</th>
                        <th>Route</th>
                        <th>Escort Time</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($pending_escorts as $report): ?>
                        <tr>
                            <td>#<?= $report['id'] ?></td>
                            <td>
                                <strong><?= clean($report['ic_name']) ?></strong><br>
                                <small><?= clean($report['badge_number']) ?> - <?= clean($report['rank']) ?></small>
                            </td>
                            <td><?= clean($report['ic_escorting']) ?></td>
                            <td><?= clean($report['from_location']) ?> → <?= clean($report['to_location']) ?></td>
                            <td><?= formatDate($report['escort_time']) ?></td>
                            <td><span class="badge badge-<?= $report['status'] ?>"><?= ucfirst($report['status']) ?></span></td>
                            <td>
                                <a href="/doc/forms/escorting_report.php?action=view&id=<?= $report['id'] ?>" class="btn btn-sm">View</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
    
    <div class="form-section">
        <h3>🏢 Bolingbroke Activities (<?= count($pending_bb) ?>)</h3>
        <?php if (empty($pending_bb)): ?>
            <p>No pending bolingbroke activities.</p>
        <?php else: ?>
            <table class="data-table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Submitted By</th>
                        <th>Shift Leader</th>
                        <th>Activity Date</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($pending_bb as $activity): ?>
                        <tr>
                            <td>#<?= $activity['id'] ?></td>
                            <td>
                                <strong><?= clean($activity['ic_name']) ?></strong><br>
                                <small><?= clean($activity['badge_number']) ?> - <?= clean($activity['rank']) ?></small>
                            </td>
                            <td><?= clean($activity['shift_leader']) ?></td>
                            <td><?= formatDate($activity['activity_datetime']) ?></td>
                            <td><span class="badge badge-<?= $activity['status'] ?>"><?= ucfirst($activity['status']) ?></span></td>
                            <td>
                                <a href="/doc/forms/bolingbroke_activity.php?action=view&id=<?= $activity['id'] ?>" class="btn btn-sm">View</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
    
    <div class="form-section">
        <h3>⚖️ Parole Forms (<?= count($pending_parole) ?>)</h3>
        <?php if (empty($pending_parole)): ?>
            <p>No pending parole forms.</p>
        <?php else: ?>
            <table class="data-table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Submitted By</th>
                        <th>Inmate Name</th>
                        <th>Charge</th>
                        <th>End of Parole</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($pending_parole as $parole): ?>
                        <tr>
                            <td>#<?= $parole['id'] ?></td>
                            <td>
                                <strong><?= clean($parole['ic_name']) ?></strong><br>
                                <small><?= clean($parole['badge_number']) ?> - <?= clean($parole['rank']) ?></small>
                            </td>
                            <td><?= clean($parole['inmate_name']) ?></td>
                            <td><?= clean($parole['charge']) ?></td>
                            <td><?= date('M d, Y', strtotime($parole['end_of_parole'])) ?></td>
                            <td><span class="badge badge-<?= $parole['status'] ?>"><?= ucfirst($parole['status']) ?></span></td>
                            <td>
                                <a href="/doc/forms/parole_form.php?action=view&id=<?= $parole['id'] ?>" class="btn btn-sm">View</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>

<?php elseif ($action === 'user_status'): ?>
    <div class="page-header">
        <h2>👤 User Status Management</h2>
    </div>
    
    <?php
    $users = $conn->query("
        SELECT u.*, r.display_name as rank_name, r.level as rank_level, d.code as division_code
        FROM users u
        JOIN ranks r ON u.rank_id = r.id
        LEFT JOIN divisions d ON u.division_id = d.id
        WHERE u.status != 'pending'
        ORDER BY u.status, u.ic_name
    ")->fetch_all(MYSQLI_ASSOC);
    ?>
    
    <table class="data-table">
        <thead>
            <tr>
                <th>ID</th>
                <th>IC Name</th>
                <th>Badge</th>
                <th>Rank</th>
                <th>Division</th>
                <th>Current Status</th>
                <th>Last Login</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($users as $user): ?>
                <tr>
                    <td><?= $user['id'] ?></td>
                    <td><strong><?= clean($user['ic_name']) ?></strong></td>
                    <td><?= clean($user['badge_number']) ?></td>
                    <td>
                        <span class="rank-badge" style="background: <?= getRankColor($user['rank_level']) ?>">
                            <?= clean($user['rank_name']) ?>
                        </span>
                    </td>
                    <td>
                        <span class="badge badge-secondary">
                            <?= clean($user['division_code'] ?? 'OPS') ?>
                        </span>
                    </td>
                    <td>
                        <span class="badge badge-<?= $user['status'] ?>">
                            <?= ucfirst($user['status']) ?>
                        </span>
                    </td>
                    <td><?= $user['last_login'] ? timeAgo($user['last_login']) : 'Never' ?></td>
                    <td>
                        <form method="POST" style="display: inline;">
                            <input type="hidden" name="csrf_token" value="<?= generateToken() ?>">
                            <input type="hidden" name="user_id" value="<?= $user['id'] ?>">
                            <select name="status" onchange="this.form.submit()" style="padding: 5px;">
                                <option value="">Change Status...</option>
                                <option value="active" <?= $user['status'] === 'active' ? 'disabled' : '' ?>>Active</option>
                                <option value="inactive" <?= $user['status'] === 'inactive' ? 'disabled' : '' ?>>Inactive</option>
                                <option value="suspended" <?= $user['status'] === 'suspended' ? 'disabled' : '' ?>>Suspended</option>
                            </select>
                        </form>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php endif; ?>

<?php include __DIR__ . '/../assets/includes/footer.php'; ?>
