<?php
require_once __DIR__ . '/../config/auth.php';

// Get statistics
$stats = [];

// Total users
$result = $conn->query("SELECT COUNT(*) as count FROM users WHERE status = 'active'");
$stats['total_users'] = $result->fetch_assoc()['count'];

// Total threads
$result = $conn->query("SELECT COUNT(*) as count FROM threads");
$stats['total_threads'] = $result->fetch_assoc()['count'];

// Total posts
$result = $conn->query("SELECT COUNT(*) as count FROM posts");
$stats['total_posts'] = $result->fetch_assoc()['count'];

// Online users (active in last 5 minutes)
$result = $conn->query("
    SELECT COUNT(DISTINCT user_id) as count 
    FROM activity_logs 
    WHERE created_at > DATE_SUB(NOW(), INTERVAL 5 MINUTE)
");
$stats['online_users'] = $result->fetch_assoc()['count'];

// Recent threads
$recent_threads = $conn->query("
    SELECT t.*, u.ic_name, u.badge_number, u.rank_id, r.display_name as rank_display,
           c.name as category_name,
           (SELECT COUNT(*) FROM posts WHERE thread_id = t.id) as post_count
    FROM threads t
    JOIN users u ON t.user_id = u.id
    JOIN ranks r ON u.rank_id = r.id
    JOIN forum_categories c ON t.category_id = c.id
    ORDER BY t.created_at DESC
    LIMIT 10
")->fetch_all(MYSQLI_ASSOC);

// Recent activity (per user)
$recent_activity = $conn->query("
    SELECT a.*, u.ic_name, u.badge_number 
    FROM activity_logs a
    LEFT JOIN users u ON a.user_id = u.id
    WHERE a.user_id = {$_SESSION['user_id']}
    ORDER BY a.created_at DESC
    LIMIT 50
")->fetch_all(MYSQLI_ASSOC);

// Pending forms counts
$pending_escorts = 0;
$pending_bolingbroke = 0;
$pending_paroles = 0;

if (hasPermission('forms.review')) {
    $result = $conn->query("SELECT COUNT(*) as count FROM escorting_reports WHERE status IN ('draft', 'submitted')");
    $pending_escorts = $result->fetch_assoc()['count'];
    
    $result = $conn->query("SELECT COUNT(*) as count FROM bolingbroke_activities WHERE status IN ('draft', 'submitted')");
    $pending_bolingbroke = $result->fetch_assoc()['count'];
    
    $result = $conn->query("SELECT COUNT(*) as count FROM parole_forms WHERE status IN ('draft', 'submitted')");
    $pending_paroles = $result->fetch_assoc()['count'];
}

$page_title = 'Dashboard';
include __DIR__ . '/../assets/includes/header.php';
?>

<div class="dashboard-stats">
    <div class="stat-card">
        <div class="stat-icon">👥</div>
        <div class="stat-info">
            <h3><?= $stats['total_users'] ?></h3>
            <p>Total Members</p>
        </div>
    </div>
    
    <div class="stat-card">
        <div class="stat-icon">📝</div>
        <div class="stat-info">
            <h3><?= $stats['total_threads'] ?></h3>
            <p>Total Threads</p>
        </div>
    </div>
    
    <div class="stat-card">
        <div class="stat-icon">💬</div>
        <div class="stat-info">
            <h3><?= $stats['total_posts'] ?></h3>
            <p>Total Posts</p>
        </div>
    </div>
    
    <div class="stat-card">
        <div class="stat-icon">🟢</div>
        <div class="stat-info">
            <h3><?= $stats['online_users'] ?></h3>
            <p>Online Now</p>
        </div>
    </div>
</div>

<?php if ($pending_escorts + $pending_bolingbroke + $pending_paroles > 0): ?>
<div class="alert alert-info">
    <strong>Pending Reviews:</strong>
    <?php if ($pending_escorts > 0): ?>
        <span><?= $pending_escorts ?> Escorting Reports</span>
    <?php endif; ?>
    <?php if ($pending_bolingbroke > 0): ?>
        <span><?= $pending_bolingbroke ?> BolingBroke Activities</span>
    <?php endif; ?>
    <?php if ($pending_paroles > 0): ?>
        <span><?= $pending_paroles ?> Parole Forms</span>
    <?php endif; ?>
</div>
<?php endif; ?>

<div class="dashboard-grid">
    <div class="dashboard-section">
        <div class="section-header">
            <h2>Recent Threads</h2>
            <a href="forum.php" class="btn btn-sm">View All</a>
        </div>
        
        <div class="threads-list">
            <?php foreach ($recent_threads as $thread): ?>
                <div class="thread-item">
                    <div class="thread-info">
                        <?php if ($thread['is_pinned']): ?>
                            <span class="badge badge-warning">📌 Pinned</span>
                        <?php endif; ?>
                        <h3>
                            <a href="thread.php?id=<?= $thread['id'] ?>">
                                <?= clean($thread['title']) ?>
                            </a>
                        </h3>
                        <div class="thread-meta">
                            <span class="category"><?= clean($thread['category_name']) ?></span>
                            <span class="author">
                                by <strong><?= clean($thread['ic_name']) ?></strong>
                                <span class="rank-badge" style="background: <?= getRankColor($thread['rank_id']) ?>">
                                    <?= clean($thread['rank_display']) ?>
                                </span>
                            </span>
                            <span class="time"><?= timeAgo($thread['created_at']) ?></span>
                        </div>
                    </div>
                    <div class="thread-stats">
                        <div class="stat">
                            <span class="count"><?= $thread['post_count'] ?></span>
                            <span class="label">Replies</span>
                        </div>
                        <div class="stat">
                            <span class="count"><?= $thread['views'] ?></span>
                            <span class="label">Views</span>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
            
            <?php if (empty($recent_threads)): ?>
                <p class="no-data">No threads yet. Be the first to create one!</p>
            <?php endif; ?>
        </div>
    </div>
    
    <div class="dashboard-section">
        <div class="section-header">
            <h2>Your Recent Activity</h2>
        </div>
        
        <div class="activity-list">
            <?php foreach ($recent_activity as $activity): ?>
                <div class="activity-item">
                    <div class="activity-icon">
                        <?php
                        $icon = '•';
                        switch($activity['action']) {
                            case 'login': $icon = '🔐'; break;
                            case 'logout': $icon = '🚪'; break;
                            case 'thread_create': $icon = '📝'; break;
                            case 'post_create': $icon = '💬'; break;
                            case 'form_submit': $icon = '📋'; break;
                        }
                        echo $icon;
                        ?>
                    </div>
                    <div class="activity-content">
                        <strong><?= clean($activity['ic_name'] ?? 'System') ?></strong>
                        <span><?= clean($activity['description'] ?: $activity['action']) ?></span>
                    </div>
                    <div class="activity-time">
                        <?= timeAgo($activity['created_at']) ?>
                    </div>
                </div>
            <?php endforeach; ?>
            
            <?php if (empty($recent_activity)): ?>
                <p class="no-data">No recent activity</p>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php include __DIR__ . '/../assets/includes/footer.php'; ?>