<?php
require_once __DIR__ . '/../config/auth.php';
requirePermission('forms.parole');

$action = $_GET['action'] ?? 'list';
$id = (int)($_GET['id'] ?? 0);

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $token = $_POST['csrf_token'] ?? '';
    if (!verifyToken($token)) die('Invalid token');
    
    $post_action = $_POST['action'] ?? '';
    
    // Handle approval/rejection
    if ($post_action === 'approve' || $post_action === 'reject') {
        requirePermission('forms.review');
        $new_status = $post_action === 'approve' ? 'approved' : 'rejected';
        $review_notes = sanitizeInput($_POST['review_notes'] ?? '');
        
        $stmt = $conn->prepare("UPDATE parole_forms SET status=?, reviewed_by=?, reviewed_at=NOW(), review_notes=? WHERE id=?");
        $stmt->bind_param('sisi', $new_status, $_SESSION['user_id'], $review_notes, $id);
        $stmt->execute();
        
        logActivity('form_review', "Parole form $post_action: #$id");
        redirect('parole_form?action=view&id=' . $id);
    }
    
    // Handle create/update
    $inmate_name = sanitizeInput($_POST['inmate_name']);
    $mdt_case_id = sanitizeInput($_POST['mdt_case_id']);
    $charge = sanitizeInput($_POST['charge']);
    $sentence_start = $_POST['sentence_start'];
    $parole_conditions = sanitizeInput($_POST['parole_conditions']);
    $end_of_parole = $_POST['end_of_parole'];
    $officer_leader = sanitizeInput($_POST['officer_leader']);
    
    // Determine status based on which button was clicked
    $status = isset($_POST['submit_report']) ? 'submitted' : 'draft';
    
    if ($id > 0) {
        $stmt = $conn->prepare("UPDATE parole_forms SET inmate_name=?, mdt_case_id=?, charge=?, sentence_start=?, parole_conditions=?, end_of_parole=?, officer_leader=?, status=? WHERE id=? AND user_id=?");
        $stmt->bind_param('ssssssssii', $inmate_name, $mdt_case_id, $charge, $sentence_start, $parole_conditions, $end_of_parole, $officer_leader, $status, $id, $_SESSION['user_id']);
    } else {
        $stmt = $conn->prepare("INSERT INTO parole_forms (user_id, inmate_name, mdt_case_id, charge, sentence_start, parole_conditions, end_of_parole, officer_leader, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param('issssssss', $_SESSION['user_id'], $inmate_name, $mdt_case_id, $charge, $sentence_start, $parole_conditions, $end_of_parole, $officer_leader, $status);
    }
    
    $stmt->execute();
    logActivity('form_submit', 'Parole form submitted for: ' . $inmate_name);
    redirect('parole_form');
}

// Show form
if ($action === 'new' || $action === 'edit') {
    $parole = null;
    if ($id > 0) {
        $result = $conn->query("SELECT * FROM parole_forms WHERE id = $id AND user_id = {$_SESSION['user_id']}");
        $parole = $result->fetch_assoc();
        if (!$parole) die('Not found');
    }
    
    $page_title = ($action === 'new' ? 'New' : 'Edit') . ' Parole Form';
    include __DIR__ . '/../assets/includes/header.php';
    ?>
    
    <div class="page-header">
        <h1>📋 <?= $page_title ?></h1>
    </div>
    
    <form method="POST" class="doc-form">
        <input type="hidden" name="csrf_token" value="<?= generateToken() ?>">
        
        <div class="form-row">
            <div class="form-group">
                <label for="inmate_name">Inmate Name *</label>
                <input type="text" name="inmate_name" id="inmate_name" required 
                       value="<?= clean($parole['inmate_name'] ?? '') ?>">
            </div>
            <div class="form-group">
                <label for="mdt_case_id">MDT Case ID *</label>
                <input type="text" name="mdt_case_id" id="mdt_case_id" required 
                       value="<?= clean($parole['mdt_case_id'] ?? '') ?>">
            </div>
        
        <div class="form-group">
            <label for="charge">Charge *</label>
            <input type="text" name="charge" id="charge" required 
                   value="<?= clean($parole['charge'] ?? '') ?>">
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label for="sentence_start">Sentence Start Date *</label>
                <input type="date" name="sentence_start" id="sentence_start" required 
                       value="<?= $parole['sentence_start'] ?? '' ?>">
            </div>
            <div class="form-group">
                <label for="end_of_parole">End of Parole *</label>
                <input type="date" name="end_of_parole" id="end_of_parole" required 
                       value="<?= $parole['end_of_parole'] ?? '' ?>">
            </div>
        </div>
        
        <div class="form-group">
            <label for="parole_conditions">Parole Conditions *</label>
            <textarea name="parole_conditions" id="parole_conditions" rows="6" required><?= clean($parole['parole_conditions'] ?? '') ?></textarea>
            <small>List all conditions that must be met during parole</small>
        </div>
        
        <div class="form-group">
            <label for="officer_leader">Officer Leader *</label>
            <input type="text" name="officer_leader" id="officer_leader" required 
                   value="<?= clean($parole['officer_leader'] ?? '') ?>">
        </div>
        
        <button type="submit" name="save_draft" class="btn btn-secondary no-loading">💾 Save as Draft</button>
        <button type="submit" name="submit_report" class="btn btn-primary no-loading">📤 Submit for Review</button>
        <a href="parole_form.php" class="btn btn-secondary">Cancel</a>
    </form>
    
    <?php
    include __DIR__ . '/../assets/includes/footer.php';
    exit;
}

// View detail
if ($action === 'view' && $id > 0) {
    $result = $conn->query("SELECT p.*, u.ic_name as officer_name, u.badge_number, r.ic_name as reviewer_name, r.badge_number as reviewer_badge FROM parole_forms p JOIN users u ON p.user_id = u.id LEFT JOIN users r ON p.reviewed_by = r.id WHERE p.id = $id");
    $parole = $result->fetch_assoc();
    if (!$parole) die('Parole form not found');
    
    $can_review = hasPermission('forms.review');
    
    $page_title = 'Parole Form Details';
    include __DIR__ . '/../assets/includes/header.php';
    ?>
    
    <div class="page-header">
        <h1>📋 Parole Form #<?= $parole['id'] ?></h1>
        <div>
            <a href="parole_form.php" class="btn btn-secondary">← Back</a>
            <?php if ($parole['user_id'] == $_SESSION['user_id'] && $parole['status'] === 'draft'): ?>
                <a href="?action=edit&id=<?= $id ?>" class="btn">Edit</a>
            <?php endif; ?>
        </div>
    </div>
    
    <div class="doc-form" style="max-width: 900px;">
        <div class="form-section">
            <h2>Form Information</h2>
            <div class="detail-grid">
                <div class="detail-item">
                    <label>Status</label>
                    <span class="badge badge-<?= $parole['status'] ?>"><?= ucfirst($parole['status']) ?></span>
                </div>
                <div class="detail-item">
                    <label>Submitted By</label>
                    <strong><?= clean($parole['officer_name']) ?></strong><br>
                    <small>Badge #<?= clean($parole['badge_number']) ?></small>
                </div>
                <div class="detail-item">
                    <label>Submitted On</label>
                    <?= formatDate($parole['created_at']) ?>
                </div>
            </div>
        </div>
        
        <div class="form-section">
            <h2>Inmate Information</h2>
            
            <div class="detail-item">
                <label>Inmate Name</label>
                <strong><?= clean($parole['inmate_name']) ?></strong>
            </div>
            
            <div class="detail-item">
                <label>MDT Case ID</label>
                <?= clean($parole['mdt_case_id']) ?>
            </div>
            
            <div class="detail-item">
                <label>Charge</label>
                <?= clean($parole['charge']) ?>
            </div>
            
            <div class="detail-item">
                <label>Sentence Start Date</label>
                <?= formatDate($parole['sentence_start'], 'M d, Y') ?>
            </div>
            
            <div class="detail-item">
                <label>End of Parole</label>
                <?= formatDate($parole['end_of_parole'], 'M d, Y') ?>
            </div>
            
            <div class="detail-item">
                <label>Parole Conditions</label>
                <div style="white-space: pre-wrap;"><?= clean($parole['parole_conditions']) ?></div>
            </div>
            
            <div class="detail-item">
                <label>Officer Leader</label>
                <strong><?= clean($parole['officer_leader']) ?></strong>
            </div>
        </div>
        
        <?php if ($parole['reviewed_at']): ?>
            <div class="form-section">
                <h2>Review Information</h2>
                <div class="detail-grid">
                    <div class="detail-item">
                        <label>Reviewed By</label>
                        <strong><?= clean($parole['reviewer_name']) ?></strong><br>
                        <small>Badge #<?= clean($parole['reviewer_badge']) ?></small>
                    </div>
                    <div class="detail-item">
                        <label>Reviewed On</label>
                        <?= formatDate($parole['reviewed_at']) ?>
                    </div>
                </div>
                <?php if ($parole['review_notes']): ?>
                    <div class="detail-item">
                        <label>Review Notes</label>
                        <div style="white-space: pre-wrap;"><?= clean($parole['review_notes']) ?></div>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>
        
        <?php if ($can_review && in_array($parole['status'], ['draft', 'submitted'])): ?>
            <div class="form-section">
                <h2>Review Actions</h2>
                <form method="POST" style="margin-bottom: 20px;">
                    <input type="hidden" name="csrf_token" value="<?= generateToken() ?>">
                    <input type="hidden" name="action" value="approve">
                    <div class="form-group">
                        <label for="review_notes">Review Notes (Optional)</label>
                        <textarea name="review_notes" id="review_notes" rows="3"></textarea>
                    </div>
                    <button type="submit" class="btn no-loading" style="background: #27ae60;" onclick="return confirm('Approve this parole form?');">✓ Approve</button>
                </form>
                <form method="POST">
                    <input type="hidden" name="csrf_token" value="<?= generateToken() ?>">
                    <input type="hidden" name="action" value="reject">
                    <div class="form-group">
                        <label for="reject_notes">Rejection Reason *</label>
                        <textarea name="review_notes" id="reject_notes" rows="3" required></textarea>
                    </div>
                    <button type="submit" class="btn no-loading" style="background: #e74c3c;" onclick="return confirm('Reject this parole form?');">✗ Reject</button>
                </form>
            </div>
        <?php endif; ?>
    </div>
    
    <?php
    include __DIR__ . '/../assets/includes/footer.php';
    exit;
}

// List view
$page = max(1, (int)($_GET['page'] ?? 1));
$per_page = 20;

$can_review = hasPermission('forms.review');
$where = $can_review ? '' : "WHERE p.user_id = {$_SESSION['user_id']}";

$result = $conn->query("SELECT COUNT(*) as total FROM parole_forms p $where");
$total = $result->fetch_assoc()['total'];
$pagination = paginate($total, $per_page, $page);

$forms = $conn->query("
    SELECT p.*, u.ic_name, u.badge_number, 
           r.ic_name as reviewer_name
    FROM parole_forms p
    JOIN users u ON p.user_id = u.id
    LEFT JOIN users r ON p.reviewed_by = r.id
    $where
    ORDER BY p.created_at DESC
    LIMIT {$pagination['offset']}, $per_page
")->fetch_all(MYSQLI_ASSOC);

$page_title = 'Parole Forms';
include __DIR__ . '/../assets/includes/header.php';
?>

<div class="page-header">
    <h1>📋 Parole Forms</h1>
    <a href="parole_form.php?action=new" class="btn btn-primary">+ New Parole Form</a>
</div>

<table class="data-table">
    <thead>
        <tr>
            <th>Officer</th>
            <th>Inmate</th>
            <th>Charge</th>
            <th>Parole End</th>
            <th>Status</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($forms as $form): ?>
            <tr>
                <td>
                    <?= clean($form['ic_name']) ?><br>
                    <small>#<?= clean($form['badge_number']) ?></small>
                </td>
                <td>
                    <strong><?= clean($form['inmate_name']) ?></strong><br>
                    <small>Case: <?= clean($form['mdt_case_id']) ?></small>
                </td>
                <td><?= clean($form['charge']) ?></td>
                <td><?= formatDate($form['end_of_parole'], 'M d, Y') ?></td>
                <td>
                    <span class="badge badge-<?= $form['status'] ?>"><?= ucfirst($form['status']) ?></span>
                    <?php if ($form['reviewer_name']): ?>
                        <br><small>by <?= clean($form['reviewer_name']) ?></small>
                    <?php endif; ?>
                </td>
                <td>
                    <?php if ($form['user_id'] == $_SESSION['user_id'] && $form['status'] === 'draft'): ?>
                        <a href="?action=edit&id=<?= $form['id'] ?>" class="btn btn-sm">Edit</a>
                    <?php endif; ?>
                    <a href="?action=view&id=<?= $form['id'] ?>" class="btn btn-sm">View</a>
                </td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<?php if ($pagination['total_pages'] > 1): ?>
    <div class="pagination">
        <?php for ($i = 1; $i <= $pagination['total_pages']; $i++): ?>
            <a href="?page=<?= $i ?>" class="<?= $i === $page ? 'active' : '' ?>"><?= $i ?></a>
        <?php endfor; ?>
    </div>
<?php endif; ?>

<?php include __DIR__ . '/../assets/includes/footer.php'; ?>