<?php
require_once __DIR__ . '/../config/auth.php';
requirePermission('forms.escort');

$action = $_GET['action'] ?? 'list';
$id = (int)($_GET['id'] ?? 0);

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $token = $_POST['csrf_token'] ?? '';
    if (!verifyToken($token)) die('Invalid token');
    
    $post_action = $_POST['action'] ?? '';
    
    // Handle approval/rejection
    if ($post_action === 'approve' || $post_action === 'reject') {
        requirePermission('forms.review');
        $new_status = $post_action === 'approve' ? 'approved' : 'rejected';
        $review_notes = sanitizeInput($_POST['review_notes'] ?? '');
        
        $stmt = $conn->prepare("UPDATE escorting_reports SET status=?, reviewed_by=?, reviewed_at=NOW(), review_notes=? WHERE id=?");
        $stmt->bind_param('sisi', $new_status, $_SESSION['user_id'], $review_notes, $id);
        $stmt->execute();
        
        logActivity('form_review', "Escorting report $post_action: #$id");
        redirect('escorting_report?action=view&id=' . $id);
    }
    
    // Handle create/update
    $ic_escorting = sanitizeInput($_POST['ic_escorting']);
    $officer_involved = sanitizeInput($_POST['officer_involved']);
    $mdt_case_id = sanitizeInput($_POST['mdt_case_id']);
    $from_location = sanitizeInput($_POST['from_location']);
    $to_location = sanitizeInput($_POST['to_location']);
    $escort_time = $_POST['escort_time'];
    $debrief = sanitizeInput($_POST['debrief']);
    
    if ($id > 0) {
        $stmt = $conn->prepare("UPDATE escorting_reports SET ic_escorting=?, officer_involved=?, mdt_case_id=?, from_location=?, to_location=?, escort_time=?, debrief=? WHERE id=? AND user_id=?");
        $stmt->bind_param('sssssssii', $ic_escorting, $officer_involved, $mdt_case_id, $from_location, $to_location, $escort_time, $debrief, $id, $_SESSION['user_id']);
    } else {
        $stmt = $conn->prepare("INSERT INTO escorting_reports (user_id, ic_escorting, officer_involved, mdt_case_id, from_location, to_location, escort_time, debrief) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param('isssssss', $_SESSION['user_id'], $ic_escorting, $officer_involved, $mdt_case_id, $from_location, $to_location, $escort_time, $debrief);
    }
    
    $stmt->execute();
    logActivity('form_submit', 'Escorting report submitted');
    redirect('escorting_report');
}

// Show form
if ($action === 'new' || $action === 'edit') {
    $report = null;
    if ($id > 0) {
        $result = $conn->query("SELECT * FROM escorting_reports WHERE id = $id AND user_id = {$_SESSION['user_id']}");
        $report = $result->fetch_assoc();
        if (!$report) die('Not found');
    }
    
    $page_title = ($action === 'new' ? 'New' : 'Edit') . ' Escorting Report';
    include __DIR__ . '/../assets/includes/header.php';
    ?>
    
    <div class="page-header">
        <h1>🚓 <?= $page_title ?></h1>
    </div>
    
    <form method="POST" class="doc-form">
        <input type="hidden" name="csrf_token" value="<?= generateToken() ?>">
        
        <div class="form-row">
            <div class="form-group">
                <label for="ic_escorting">IC Escorting *</label>
                <input type="text" name="ic_escorting" id="ic_escorting" required value="<?= clean($report['ic_escorting'] ?? '') ?>">
            </div>
            <div class="form-group">
                <label for="mdt_case_id">MDT Case ID</label>
                <input type="text" name="mdt_case_id" id="mdt_case_id" value="<?= clean($report['mdt_case_id'] ?? '') ?>">
            </div>
        </div>
        
        <div class="form-group">
            <label for="officer_involved">Officer Involved *</label>
            <textarea name="officer_involved" id="officer_involved" rows="3" required placeholder="List all officers involved..."><?= clean($report['officer_involved'] ?? '') ?></textarea>
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label for="from_location">From Location *</label>
                <input type="text" name="from_location" id="from_location" required value="<?= clean($report['from_location'] ?? '') ?>">
            </div>
            <div class="form-group">
                <label for="to_location">To Location *</label>
                <input type="text" name="to_location" id="to_location" required value="<?= clean($report['to_location'] ?? '') ?>">
            </div>
        </div>
        
        <div class="form-group">
            <label for="escort_time">Escort Date/Time *</label>
            <input type="datetime-local" name="escort_time" id="escort_time" required value="<?= $report['escort_time'] ?? '' ?>">
        </div>
        
        <div class="form-group">
            <label for="debrief">Debrief</label>
            <textarea name="debrief" id="debrief" rows="6" placeholder="Provide debrief details..."><?= clean($report['debrief'] ?? '') ?></textarea>
        </div>
        
        <button type="submit" name="save_draft" class="btn btn-secondary no-loading">💾 Save as Draft</button>
        <button type="submit" name="submit_report" class="btn btn-primary no-loading">📤 Submit for Review</button>
        <a href="escorting_report.php" class="btn btn-secondary">Cancel</a>
    </form>
    
    <?php
    include __DIR__ . '/../assets/includes/footer.php';
    exit;
}

// View detail
if ($action === 'view' && $id > 0) {
    $result = $conn->query("SELECT e.*, u.ic_name as officer_name, u.badge_number, r.ic_name as reviewer_name, r.badge_number as reviewer_badge FROM escorting_reports e JOIN users u ON e.user_id = u.id LEFT JOIN users r ON e.reviewed_by = r.id WHERE e.id = $id");
    $report = $result->fetch_assoc();
    if (!$report) die('Report not found');
    
    $can_review = hasPermission('forms.review');
    
    $page_title = 'Escorting Report Details';
    include __DIR__ . '/../assets/includes/header.php';
    ?>
    
    <div class="page-header">
        <h1>🚓 Escorting Report #<?= $report['id'] ?></h1>
        <div>
            <a href="escorting_report.php" class="btn btn-secondary">← Back</a>
            <?php if ($report['user_id'] == $_SESSION['user_id'] && $report['status'] === 'draft'): ?>
                <a href="?action=edit&id=<?= $id ?>" class="btn">Edit</a>
            <?php endif; ?>
        </div>
    </div>
    
    <div class="doc-form" style="max-width: 900px;">
        <div class="form-section">
            <h2>Report Information</h2>
            <div class="detail-grid">
                <div class="detail-item">
                    <label>Status</label>
                    <span class="badge badge-<?= $report['status'] ?>"><?= ucfirst($report['status']) ?></span>
                </div>
                <div class="detail-item">
                    <label>Submitted By</label>
                    <strong><?= clean($report['officer_name']) ?></strong><br>
                    <small>Badge #<?= clean($report['badge_number']) ?></small>
                </div>
                <div class="detail-item">
                    <label>Submitted On</label>
                    <?= formatDate($report['created_at']) ?>
                </div>
            </div>
        </div>
        
        <div class="form-section">
            <h2>Escorting Details</h2>
            <div class="detail-grid">
                <div class="detail-item">
                    <label>IC Escorting</label>
                    <strong><?= clean($report['ic_escorting']) ?></strong>
                </div>
                <div class="detail-item">
                    <label>MDT Case ID</label>
                    <?= clean($report['mdt_case_id']) ?: 'N/A' ?>
                </div>
            </div>
            
            <div class="detail-item">
                <label>Officer Involved</label>
                <div style="white-space: pre-wrap;"><?= clean($report['officer_involved']) ?></div>
            </div>
            
            <div class="detail-grid">
                <div class="detail-item">
                    <label>From Location</label>
                    <?= clean($report['from_location']) ?>
                </div>
                <div class="detail-item">
                    <label>To Location</label>
                    <?= clean($report['to_location']) ?>
                </div>
            </div>
            
            <div class="detail-item">
                <label>Escort Date/Time</label>
                <?= formatDate($report['escort_time']) ?>
            </div>
            
            <?php if ($report['debrief']): ?>
                <div class="detail-item">
                    <label>Debrief</label>
                    <div style="white-space: pre-wrap;"><?= clean($report['debrief']) ?></div>
                </div>
            <?php endif; ?>
        </div>
        
        <?php if ($report['reviewed_at']): ?>
            <div class="form-section">
                <h2>Review Information</h2>
                <div class="detail-grid">
                    <div class="detail-item">
                        <label>Reviewed By</label>
                        <strong><?= clean($report['reviewer_name']) ?></strong><br>
                        <small>Badge #<?= clean($report['reviewer_badge']) ?></small>
                    </div>
                    <div class="detail-item">
                        <label>Reviewed On</label>
                        <?= formatDate($report['reviewed_at']) ?>
                    </div>
                </div>
                <?php if ($report['review_notes']): ?>
                    <div class="detail-item">
                        <label>Review Notes</label>
                        <div style="white-space: pre-wrap;"><?= clean($report['review_notes']) ?></div>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>
        
        <?php if ($can_review && in_array($report['status'], ['draft', 'submitted'])): ?>
            <div class="form-section">
                <h2>Review Actions</h2>
                <form method="POST" style="margin-bottom: 20px;">
                    <input type="hidden" name="csrf_token" value="<?= generateToken() ?>">
                    <input type="hidden" name="action" value="approve">
                    <div class="form-group">
                        <label for="review_notes">Review Notes (Optional)</label>
                        <textarea name="review_notes" id="review_notes" rows="3"></textarea>
                    </div>
                    <button type="submit" class="btn no-loading" style="background: #27ae60;" onclick="return confirm('Approve this report?');">✓ Approve</button>
                </form>
                <form method="POST">
                    <input type="hidden" name="csrf_token" value="<?= generateToken() ?>">
                    <input type="hidden" name="action" value="reject">
                    <div class="form-group">
                        <label for="reject_notes">Rejection Reason *</label>
                        <textarea name="review_notes" id="reject_notes" rows="3" required></textarea>
                    </div>
                    <button type="submit" class="btn no-loading" style="background: #e74c3c;" onclick="return confirm('Reject this report?');">✗ Reject</button>
                </form>
            </div>
        <?php endif; ?>
    </div>
    
    <?php
    include __DIR__ . '/../assets/includes/footer.php';
    exit;
}

// List view
$page = max(1, (int)($_GET['page'] ?? 1));
$per_page = 20;
$can_review = hasPermission('forms.review');
$where = $can_review ? '' : "WHERE user_id = {$_SESSION['user_id']}";

$result = $conn->query("SELECT COUNT(*) as total FROM escorting_reports $where");
$total = $result->fetch_assoc()['total'];
$pagination = paginate($total, $per_page, $page);

$reports = $conn->query("SELECT e.*, u.ic_name, u.badge_number FROM escorting_reports e JOIN users u ON e.user_id = u.id $where ORDER BY e.created_at DESC LIMIT {$pagination['offset']}, $per_page")->fetch_all(MYSQLI_ASSOC);

$page_title = 'Escorting Reports';
include __DIR__ . '/../assets/includes/header.php';
?>

<div class="page-header">
    <h1>🚓 Escorting Reports</h1>
    <a href="escorting_report.php?action=new" class="btn btn-primary">+ New Report</a>
</div>

<table class="data-table">
    <thead>
        <tr>
            <th>Officer</th>
            <th>IC Escorting</th>
            <th>From → To</th>
            <th>Date/Time</th>
            <th>Status</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($reports as $report): ?>
            <tr>
                <td>
                    <?= clean($report['ic_name']) ?><br>
                    <small>#<?= clean($report['badge_number']) ?></small>
                </td>
                <td><?= clean($report['ic_escorting']) ?></td>
                <td><?= clean($report['from_location']) ?> → <?= clean($report['to_location']) ?></td>
                <td><?= formatDate($report['escort_time']) ?></td>
                <td><span class="badge badge-<?= $report['status'] ?>"><?= ucfirst($report['status']) ?></span></td>
                <td>
                    <?php if ($report['user_id'] == $_SESSION['user_id'] && $report['status'] === 'draft'): ?>
                        <a href="?action=edit&id=<?= $report['id'] ?>" class="btn btn-sm">Edit</a>
                    <?php endif; ?>
                    <a href="?action=view&id=<?= $report['id'] ?>" class="btn btn-sm">View</a>
                </td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<?php if ($pagination['total_pages'] > 1): ?>
    <div class="pagination">
        <?php for ($i = 1; $i <= $pagination['total_pages']; $i++): ?>
            <a href="?page=<?= $i ?>" class="<?= $i === $page ? 'active' : '' ?>"><?= $i ?></a>
        <?php endfor; ?>
    </div>
<?php endif; ?>

<?php include __DIR__ . '/../assets/includes/footer.php'; ?>
