<?php
require_once __DIR__ . '/../config/auth.php';
requirePermission('forms.bolingbroke');

$action = $_GET['action'] ?? 'list';
$id = (int)($_GET['id'] ?? 0);

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $token = $_POST['csrf_token'] ?? '';
    if (!verifyToken($token)) die('Invalid token');
    
    $post_action = $_POST['action'] ?? '';
    
    // Handle approval/rejection
    if ($post_action === 'approve' || $post_action === 'reject') {
        requirePermission('forms.review');
        $new_status = $post_action === 'approve' ? 'approved' : 'rejected';
        $review_notes = sanitizeInput($_POST['review_notes'] ?? '');
        
        $stmt = $conn->prepare("UPDATE bolingbroke_activities SET status=?, reviewed_by=?, reviewed_at=NOW(), review_notes=? WHERE id=?");
        $stmt->bind_param('sisi', $new_status, $_SESSION['user_id'], $review_notes, $id);
        $stmt->execute();
        
        logActivity('form_review', "Bolingbroke activity $post_action: #$id");
        redirect('bolingbroke_activity?action=view&id=' . $id);
    }
    
    // Handle create/update
    $shift_leader = sanitizeInput($_POST['shift_leader']);
    $officer_involved = sanitizeInput($_POST['officer_involved']);
    $activity_datetime = $_POST['activity_datetime'];
    $debrief = sanitizeInput($_POST['debrief']);
    
    // Determine status based on which button was clicked
    $status = isset($_POST['submit_report']) ? 'submitted' : 'draft';
    
    if ($id > 0) {
        $stmt = $conn->prepare("UPDATE bolingbroke_activities SET shift_leader=?, officer_involved=?, activity_datetime=?, debrief=?, status=? WHERE id=? AND user_id=?");
        $stmt->bind_param('sssssii', $shift_leader, $officer_involved, $activity_datetime, $debrief, $status, $id, $_SESSION['user_id']);
    } else {
        $stmt = $conn->prepare("INSERT INTO bolingbroke_activities (user_id, shift_leader, officer_involved, activity_datetime, debrief, status) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->bind_param('isssss', $_SESSION['user_id'], $shift_leader, $officer_involved, $activity_datetime, $debrief, $status);
    }
    
    $stmt->execute();
    logActivity('form_submit', 'Bolingbroke activity submitted');
    redirect('bolingbroke_activity');
}

// Show form
if ($action === 'new' || $action === 'edit') {
    $activity = null;
    if ($id > 0) {
        $result = $conn->query("SELECT * FROM bolingbroke_activities WHERE id = $id AND user_id = {$_SESSION['user_id']}");
        $activity = $result->fetch_assoc();
        if (!$activity) die('Not found');
    }
    
    $page_title = ($action === 'new' ? 'New' : 'Edit') . ' Bolingbroke Activity';
    include __DIR__ . '/../assets/includes/header.php';
    ?>
    
    <div class="page-header">
        <h1>📋 <?= $page_title ?></h1>
    </div>
    
    <form method="POST" class="doc-form">
        <input type="hidden" name="csrf_token" value="<?= generateToken() ?>">
        
        <div class="form-group">
            <label for="shift_leader">Shift Leader *</label>
            <input type="text" name="shift_leader" id="shift_leader" required value="<?= clean($activity['shift_leader'] ?? '') ?>">
        </div>
        
        <div class="form-group">
            <label for="officer_involved">Officer Involved *</label>
            <textarea name="officer_involved" id="officer_involved" rows="3" required placeholder="List all officers involved..."><?= clean($activity['officer_involved'] ?? '') ?></textarea>
        </div>
        
        <div class="form-group">
            <label for="activity_datetime">Activity Date/Time *</label>
            <input type="datetime-local" name="activity_datetime" id="activity_datetime" required value="<?= $activity['activity_datetime'] ?? '' ?>">
        </div>
        
        <div class="form-group">
            <label for="debrief">Debrief *</label>
            <textarea name="debrief" id="debrief" rows="10" required placeholder="Provide detailed debrief of the activity..."><?= clean($activity['debrief'] ?? '') ?></textarea>
        </div>
        
        <button type="submit" name="save_draft" class="btn btn-secondary no-loading">💾 Save as Draft</button>
        <button type="submit" name="submit_report" class="btn btn-primary no-loading">📤 Submit for Review</button>
        <a href="bolingbroke_activity.php" class="btn btn-secondary">Cancel</a>
    </form>
    
    <?php
    include __DIR__ . '/../assets/includes/footer.php';
    exit;
}

// View detail
if ($action === 'view' && $id > 0) {
    $result = $conn->query("SELECT b.*, u.ic_name as officer_name, u.badge_number, r.ic_name as reviewer_name, r.badge_number as reviewer_badge FROM bolingbroke_activities b JOIN users u ON b.user_id = u.id LEFT JOIN users r ON b.reviewed_by = r.id WHERE b.id = $id");
    $activity = $result->fetch_assoc();
    if (!$activity) die('Activity not found');
    
    $can_review = hasPermission('forms.review');
    
    $page_title = 'Bolingbroke Activity Details';
    include __DIR__ . '/../assets/includes/header.php';
    ?>
    
    <div class="page-header">
        <h1>📋 Bolingbroke Activity #<?= $activity['id'] ?></h1>
        <div>
            <a href="bolingbroke_activity.php" class="btn btn-secondary">← Back</a>
            <?php if ($activity['user_id'] == $_SESSION['user_id'] && $activity['status'] === 'draft'): ?>
                <a href="?action=edit&id=<?= $id ?>" class="btn">Edit</a>
            <?php endif; ?>
        </div>
    </div>
    
    <div class="doc-form" style="max-width: 900px;">
        <div class="form-section">
            <h2>Activity Information</h2>
            <div class="detail-grid">
                <div class="detail-item">
                    <label>Status</label>
                    <span class="badge badge-<?= $activity['status'] ?>"><?= ucfirst($activity['status']) ?></span>
                </div>
                <div class="detail-item">
                    <label>Submitted By</label>
                    <strong><?= clean($activity['officer_name']) ?></strong><br>
                    <small>Badge #<?= clean($activity['badge_number']) ?></small>
                </div>
                <div class="detail-item">
                    <label>Submitted On</label>
                    <?= formatDate($activity['created_at']) ?>
                </div>
            </div>
        </div>
        
        <div class="form-section">
            <h2>Activity Details</h2>
            
            <div class="detail-item">
                <label>Shift Leader</label>
                <strong><?= clean($activity['shift_leader']) ?></strong>
            </div>
            
            <div class="detail-item">
                <label>Officer Involved</label>
                <div style="white-space: pre-wrap;"><?= clean($activity['officer_involved']) ?></div>
            </div>
            
            <div class="detail-item">
                <label>Activity Date/Time</label>
                <?= formatDate($activity['activity_datetime']) ?>
            </div>
            
            <div class="detail-item">
                <label>Debrief</label>
                <div style="white-space: pre-wrap;"><?= clean($activity['debrief']) ?></div>
            </div>
        </div>
        
        <?php if ($activity['reviewed_at']): ?>
            <div class="form-section">
                <h2>Review Information</h2>
                <div class="detail-grid">
                    <div class="detail-item">
                        <label>Reviewed By</label>
                        <strong><?= clean($activity['reviewer_name']) ?></strong><br>
                        <small>Badge #<?= clean($activity['reviewer_badge']) ?></small>
                    </div>
                    <div class="detail-item">
                        <label>Reviewed On</label>
                        <?= formatDate($activity['reviewed_at']) ?>
                    </div>
                </div>
                <?php if ($activity['review_notes']): ?>
                    <div class="detail-item">
                        <label>Review Notes</label>
                        <div style="white-space: pre-wrap;"><?= clean($activity['review_notes']) ?></div>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>
        
        <?php if ($can_review && in_array($activity['status'], ['draft', 'submitted'])): ?>
            <div class="form-section">
                <h2>Review Actions</h2>
                <form method="POST" style="margin-bottom: 20px;">
                    <input type="hidden" name="csrf_token" value="<?= generateToken() ?>">
                    <input type="hidden" name="action" value="approve">
                    <div class="form-group">
                        <label for="review_notes">Review Notes (Optional)</label>
                        <textarea name="review_notes" id="review_notes" rows="3"></textarea>
                    </div>
                    <button type="submit" class="btn no-loading" style="background: #27ae60;" onclick="return confirm('Approve this activity?');">✓ Approve</button>
                </form>
                <form method="POST">
                    <input type="hidden" name="csrf_token" value="<?= generateToken() ?>">
                    <input type="hidden" name="action" value="reject">
                    <div class="form-group">
                        <label for="reject_notes">Rejection Reason *</label>
                        <textarea name="review_notes" id="reject_notes" rows="3" required></textarea>
                    </div>
                    <button type="submit" class="btn no-loading" style="background: #e74c3c;" onclick="return confirm('Reject this activity?');">✗ Reject</button>
                </form>
            </div>
        <?php endif; ?>
    </div>
    
    <?php
    include __DIR__ . '/../assets/includes/footer.php';
    exit;
}

// List view
$page = max(1, (int)($_GET['page'] ?? 1));
$per_page = 20;
$can_review = hasPermission('forms.review');
$where = $can_review ? '' : "WHERE user_id = {$_SESSION['user_id']}";

$result = $conn->query("SELECT COUNT(*) as total FROM bolingbroke_activities $where");
$total = $result->fetch_assoc()['total'];
$pagination = paginate($total, $per_page, $page);

$activities = $conn->query("SELECT b.*, u.ic_name, u.badge_number FROM bolingbroke_activities b JOIN users u ON b.user_id = u.id $where ORDER BY b.created_at DESC LIMIT {$pagination['offset']}, $per_page")->fetch_all(MYSQLI_ASSOC);

$page_title = 'Bolingbroke Activities';
include __DIR__ . '/../assets/includes/header.php';
?>

<div class="page-header">
    <h1>📋 Bolingbroke Activities</h1>
    <a href="bolingbroke_activity.php?action=new" class="btn btn-primary">+ New Activity</a>
</div>

<table class="data-table">
    <thead>
        <tr>
            <th>Officer</th>
            <th>Shift Leader</th>
            <th>Activity Date/Time</th>
            <th>Status</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($activities as $activity): ?>
            <tr>
                <td>
                    <?= clean($activity['ic_name']) ?><br>
                    <small>#<?= clean($activity['badge_number']) ?></small>
                </td>
                <td><?= clean($activity['shift_leader']) ?></td>
                <td><?= formatDate($activity['activity_datetime']) ?></td>
                <td><span class="badge badge-<?= $activity['status'] ?>"><?= ucfirst($activity['status']) ?></span></td>
                <td>
                    <?php if ($activity['user_id'] == $_SESSION['user_id'] && $activity['status'] === 'draft'): ?>
                        <a href="?action=edit&id=<?= $activity['id'] ?>" class="btn btn-sm">Edit</a>
                    <?php endif; ?>
                    <a href="?action=view&id=<?= $activity['id'] ?>" class="btn btn-sm">View</a>
                </td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<?php if ($pagination['total_pages'] > 1): ?>
    <div class="pagination">
        <?php for ($i = 1; $i <= $pagination['total_pages']; $i++): ?>
            <a href="?page=<?= $i ?>" class="<?= $i === $page ? 'active' : '' ?>"><?= $i ?></a>
        <?php endfor; ?>
    </div>
<?php endif; ?>

<?php include __DIR__ . '/../assets/includes/footer.php'; ?>
