<?php
require_once __DIR__ . '/../config/database.php';

// Session configuration
ini_set('session.gc_maxlifetime', $_ENV['SESSION_LIFETIME'] ?? 10800);
ini_set('session.cookie_httponly', 1);
ini_set('session.use_only_cookies', 1);
ini_set('session.cookie_samesite', 'Strict');

if (!session_id()) {
    session_name($_ENV['SESSION_NAME'] ?? 'DOC_IC_SESSION');
    session_start();
}

// Session security check
function validateSession() {
    if (!isset($_SESSION['user_id'])) {
        return false;
    }
    
    // Check session timeout
    if (isset($_SESSION['last_activity']) && 
        (time() - $_SESSION['last_activity'] > ($_ENV['SESSION_LIFETIME'] ?? 10800))) {
        session_unset();
        session_destroy();
        return false;
    }
    
    $_SESSION['last_activity'] = time();
    return true;
}

// Regenerate session ID periodically
if (isset($_SESSION['user_id']) && !isset($_SESSION['last_regeneration'])) {
    $_SESSION['last_regeneration'] = time();
} elseif (isset($_SESSION['last_regeneration']) && 
          time() - $_SESSION['last_regeneration'] > 300) {
    session_regenerate_id(true);
    $_SESSION['last_regeneration'] = time();
}