<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= isset($page_title) ? clean($page_title) . ' - ' : '' ?>Department Of Corrections</title>
    <!-- Prevent flash of light theme -->
    <script>
        // Apply theme IMMEDIATELY before CSS loads to prevent flash
        (function() {
            const theme = localStorage.getItem('doc-theme');
            if (theme === 'dark') {
                document.documentElement.classList.add('dark-theme');
            }
        })();
    </script>
    <link rel="stylesheet" href="/doc/assets/css/style.css">
</head>
<body>
    <nav class="navbar">
        <div class="nav-container">
            <div class="nav-brand">
                <a href="/doc/dashboard">
                    <strong>Department Of Corrections</strong>
                </a>
            </div>
            
            <ul class="nav-menu">
                <li><a href="/doc/dashboard">Dashboard</a></li>
                <li><a href="/doc/forum">Forum</a></li>
                
                <?php if (hasPermission('forms.escort') || hasPermission('forms.bolingbroke') || hasPermission('forms.parole')): ?>
                    <li class="dropdown">
                        <a href="#" class="dropdown-toggle">Forms ▼</a>
                        <ul class="dropdown-menu">
                            <?php if (hasPermission('forms.escort')): ?>
                                <li><a href="/doc/forms/escorting_report">Escorting Report</a></li>
                            <?php endif; ?>
                            <?php if (hasPermission('forms.bolingbroke')): ?>
                                <li><a href="/doc/forms/bolingbroke_activity">BolingBroke Activity</a></li>
                            <?php endif; ?>
                            <?php if (hasPermission('forms.parole')): ?>
                                <li><a href="/doc/forms/parole_form">Parole Form</a></li>
                            <?php endif; ?>
                        </ul>
                    </li>
                <?php endif; ?>
                
                <?php 
                // Division-specific menus by rank_id
                $rank_id = $_SESSION['rank_id'] ?? 0;
                $rank_level = $_SESSION['rank_level'] ?? 0;
                
                // IA & HR: accessible by Major ADMIN (rank_id 11) or Commaderi (rank_id 9 - Commander PSB) or Deputy Chief+ (level 13+)
                $can_access_ia_hr = ($rank_id == 9 || $rank_id == 11 || $rank_level >= 13);
                
                // CTD: accessible by majora (rank_id 12 - Major DOFO) or Deputy Chief+ (level 13+)
                $can_access_ctd = ($rank_id == 12 || $rank_level >= 13);
                ?>
                
                <?php if ($can_access_ia_hr): ?>
                    <li><a href="/doc/ia">🔍 IA</a></li>
                <?php endif; ?>
                
                <?php if ($can_access_ia_hr): ?>
                    <li><a href="/doc/hr">👥 HR</a></li>
                <?php endif; ?>
                
                <?php if ($can_access_ctd): ?>
                    <li><a href="/doc/ctd">🎯 CTD</a></li>
                <?php endif; ?>
                
                <?php if (hasPermission('admin.view')): ?>
                    <li><a href="/doc/admin">Admin</a></li>
                <?php endif; ?>
            </ul>
            
            <div class="nav-user">
                <button id="theme-toggle" class="btn btn-sm" style="margin-right: 15px;" title="Toggle Dark/Light Mode">
                    <span id="theme-icon">🌙</span>
                </button>
                <div class="user-info">
                    <img src="<?= clean($_SESSION['avatar']) ?>" alt="Avatar" class="user-avatar">
                    <div class="user-details">
                        <strong><?= clean($_SESSION['ic_name']) ?></strong>
                        <span class="rank-badge" style="background: <?= getRankColor($_SESSION['rank_level']) ?>">
                            <?= clean($_SESSION['rank_display']) ?>
                        </span>
                    </div>
                </div>
                <a href="/doc/logout.php" class="btn btn-sm btn-danger">Logout</a>
            </div>
        </div>
    </nav>
    
    <main class="main-content">
        <div class="container">
